@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Détails du dossier #{{ $infofret->id }} ({{ $infofret->ntc }})</h1>

    <!-- Bouton Ajouter détail -->
    <a href="{{ route('detailleinfos.create', $infofret->id) }}" class="btn btn-success mb-3">+ Ajouter un détail</a>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if($details && $details->count() > 0)
        @foreach($details as $detail)
            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Detail #{{ $detail->id }}</h5>
                    <p><strong>Nombre Colis:</strong> {{ $detail->nombrecolis }}</p>
                    <p><strong>Poid Brut:</strong> {{ $detail->poidbrut }}</p>
                    <p><strong>Valeur:</strong> {{ $detail->valeur }}</p>
                 
                    <p><strong>Devis:</strong> {{ $detail->devis }}</p>
                    <p><strong>Agent:</strong> {{ $detail->agent?? '' }}</p>
                    <p><strong>Importateur/Exportateur:</strong> {{ $detail->importateur_exportateur ?? '' }}</p>
                 

                    <a href="{{ route('detailleinfos.show', $detail->id) }}" class="btn btn-info btn-sm">Voir</a>
                    <a href="{{ route('detailleinfos.edit', $detail->id) }}" class="btn btn-warning btn-sm">Modifier</a>
                    <form action="{{ route('detailleinfos.destroy', $detail->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ?')">Supprimer</button>
                    </form>
                </div>
            </div>
        @endforeach
    @else
        <div class="alert alert-info">Aucun détail trouvé pour ce dossier.</div>
    @endif

    <a href="{{ route('infofrets.index') }}" class="btn btn-secondary mt-3">Retour aux dossiers</a>
</div>
@endsection
